VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CMedioPago"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Public Enum AtributosMedioPago
  ControlDenominaciones = 1
  ControlIDCuenta = 2
  ControlNumero = 4
  ControlEmisor = 8
  ControlIDTitular = 16
  ControlClaveAutorizacion = 32
  MonedaExtranjera = 64
  RequiereClaveSupervisor = 128
End Enum

Public Enum ClaseIngresoSesion  ' para "mapear" el tipo de Ingreso a un elemento de sesion
  Efectivo
  Cheques
  TTCAmex
  TTCVisa
  TTCMaster
  TTCOtras
  TDebito
  OtrosMedios
End Enum

Public Codigo As String
Public Descripcion As String
Public Atributos As AtributosMedioPago
Public PorcentajeRetencionEmisor As Double
Public PorcentajeISLR As Double
Public CuentaActivo As String
Public CuentaComisiones As String
Public BancoRelacionado As String
Public Clase As ClaseIngresoSesion

Friend Sub FillCombo(cbxCombo As ComboBox)
  With cbxCombo
    .Clear
    .AddItem "Efectivo"
    .AddItem "Cheques"
    .AddItem "TC AMEX"
    .AddItem "TC VISA"
    .AddItem "TC MASTER"
    .AddItem "TC OTRAS"
    .AddItem "T.DEBITO"
    .AddItem "OTROS"
  End With
End Sub

Public Property Get TipoCambio() As Double
  TipoCambio = PorcentajeISLR
End Property

Public Property Let TipoCambio(Value As Double)
  PorcentajeISLR = TipoCambio
End Property

Public Sub LoadInstance(rs As Recordset, Optional pDest As CMedioPago = Nothing)
Dim p As CMedioPago
  Set p = pDest
  If pDest Is Nothing Then Set pDest = Me
  With pDest
    .Codigo = rs(0)
    .Descripcion = rs(1)
    .Atributos = rs(2)
    .PorcentajeRetencionEmisor = rs(3)
    .PorcentajeISLR = rs(4)
    .CuentaActivo = rs(5)
    .CuentaComisiones = rs(6)
    .BancoRelacionado = rs(7)
    .Clase = rs(8)
  End With
End Sub

Public Function Load(CodigoMedio As String) As Boolean
Dim rs As Recordset, s As String, retVal As Boolean
  s = "SELECT * FROM MediosPago WHERE Codigo = " & StringDB(CodigoMedio)
  Set rs = dbHandle.Execute(s)
  If rs.EOF Then
    retVal = False
  Else
    retVal = True
    LoadInstance rs
  End If
  rs.Close
  Set rs = Nothing
  Load = retVal
End Function

Public Function ActualizarDescriptivos(iCodigo As String, iDescripcion As String, iAtributos As AtributosMedioPago, _
  iPorcentajeRetencionEmisor As Double, iPorcentajeISLR As Double, iCuentaActivo As String, iCuentaComisiones As String, iBancoRelacionado As String, _
  iClaseIngreso As ClaseIngresoSesion)
Dim s As String, ra As Long
  s = "UPDATE MediosPago SET "
  s = s & "Descripcion = " & StringDB(iDescripcion) & ", "
  s = s & "Atributos = " & NumeroDB(iAtributos) & ", "
  s = s & "PorcentajeRetencionEmisor = " & NumeroDB(iPorcentajeRetencionEmisor) & ", "
  s = s & "PorcentajeISLR = " & NumeroDB(iPorcentajeISLR) & ", "
  s = s & "CuentaActivo = " & StringDB(iCuentaActivo) & ", "
  s = s & "CuentaComisiones = " & StringDB(iCuentaComisiones) & ", "
  s = s & "BancoRelacionado = " & StringDB(iBancoRelacionado) & ", "
  s = s & "Clase = " & NumeroDB(iClaseIngreso) & " WHERE Codigo = " & StringDB(iCodigo) & ";"
  dbHandle.Execute s, ra
  If ra = 0 Then  ' Insertar
    s = "INSERT INTO MediosPago (Codigo, Descripcion, Atributos, PorcentajeRetencionEmisor, PorcentajeISLR, CuentaActivo, CuentaComisiones, BancoRelacionado, Clase) VALUES ("
    s = s & StringDB(iCodigo) & ", " & StringDB(iDescripcion) & ", " & NumeroDB(iAtributos) & ", " & NumeroDB(iPorcentajeRetencionEmisor) & ", "
    s = s & NumeroDB(iPorcentajeISLR) & ", " & StringDB(iCuentaActivo) & ", " & StringDB(iCuentaComisiones) & ", " & StringDB(iBancoRelacionado) & ", " & NumeroDB(iClaseIngreso) & ");"
    dbHandle.Execute s
  End If
End Function

Public Function CreateNew(iCodigo As String) As Boolean
  Dim f As New frmDefinirMedioPago
  f.SetCodigo iCodigo
  f.SetContexto 3
  Unload f
  CreateNew = Load(iCodigo)
End Function

Public Sub Eliminar(sCodigo As String)
Dim s As String, rs As Recordset, l As Long
  s = "SELECT COUNT(*) FROM DetallesIngresoCaja WHERE CodigoMedio = " & StringDB(sCodigo)
  Set rs = dbHandle.Execute(s)
  l = GetNumeroFromVariant(rs(0))
  rs.Close: Set rs = Nothing
  If l > 0 Then Err.Raise 10001, "CMedioPago::Eliminar", "Hay movimientos con el medio seleccionado: eliminacion no permitida"
  s = "DELETE FROM MediosPago WHERE Codigo = " & StringDB(sCodigo)
End Sub
